﻿using System;

public partial class ReportReferral : BasePage
{
    bool batchReport = false;        

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!AccessAllowed())
        {
            Response.Redirect("ErrorPage.aspx?id=100");
        }

        if (!IsPostBack)
        {
            Session["batchReport"] = SessionItemFactory.Create(batchReport.ToString());
            Session["EFRBatchPrintOptions"] = SessionItemFactory.Create(Helpers.GetCrsSetting("EFRBatchPrintOptions"));
            Session["EFRIndividualPrintOptions"] = SessionItemFactory.Create(Helpers.GetCrsSetting("EFRIndividualPrintOptions"));

            ClientScript.RegisterStartupScript(this.GetType(), "LoadPrintOptions", "window.onload=loadReportPrintOptions();");            
        }
    }

    private bool AccessAllowed()
    {
        return true;
    }
    public override string TopMenuName()
    {
        return "Reporting";
    }

    public override string MenuItemName()
    {
        return "Referral Report";
    }

    public override string AppObjectCode()
    {
        return "EFR_REFERRAL_REPORT";
    }

}
